//
//  MCCalendarDatePickerView.h
//  MCApplication
//
//  Created by Michael Clark on 21/02/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCNibLoadingView.h"




// Defines for the bindings - they define indices into the various C style areas for keeping track of the necessary things
#define   MCCalendarDatePickerViewBindingCount              1
#define   MCCalendarDatePickerViewSelectedDateBinding    0x00
//... define more as necessary



@class MCMiniMonthView;

@interface MCCalendarDatePickerView : MCNibLoadingView {
	IBOutlet NSObjectController*   selfController;
	
	IBOutlet MCMiniMonthView*      miniMonthView;
	NSRect                         __lastMiniMonthFrame;
	
	IBOutlet NSStepper*            monthStepper;
	IBOutlet NSStepper*            dayStepper;
	IBOutlet NSStepper*            yearStepper;
	
	IBOutlet NSTextField*          monthTextField;
	IBOutlet NSTextField*          dayTextField;
	IBOutlet NSTextField*          yearTextField;
	
	
	NSCalendarDate*     __selectedDate;
	NSCalendarDate*     __visibleDate;  // Private date used for drawing calculations
	
	SEL    action;
	SEL    doubleAction;
	id     target;
	
	id     delegate;
	
	id          __observedObjects[MCCalendarDatePickerViewBindingCount];
	NSString*   __observedKeyPaths[MCCalendarDatePickerViewBindingCount];	
	BOOL __selfSet;  // Stupid - flag used to prevent us from being updated when we trigger a bindings change	
	
	BOOL __drawBackground;
	BOOL __drawBorder;
}

- (IBAction)monthStepperActed: (id)sender;
- (IBAction)dayStepperActed: (id)sender;
- (IBAction)yearStepperActed: (id)sender;

- (IBAction)gotoToday: (id)sender;

- (IBAction)gotoNextMonth: (id)sender;
- (IBAction)gotoPrevMonth: (id)sender;




- (SEL)action;
- (void)setAction:(SEL)anAction;
- (SEL)doubleAction;
- (void)setDoubleAction:(SEL)aDoubleAction;
- (id)target;
- (void)setTarget:(id)aTarget;

- (NSCalendarDate *)selectedDate;
- (void)setSelectedDate:(NSCalendarDate *)aSelectedDate;
- (NSCalendarDate *)visibleDate;
- (void)setVisibleDate:(NSCalendarDate *)aVisibleDate;

- (BOOL)drawBackground;
- (void)setDrawBackground:(BOOL)flag;

- (BOOL)drawBorder;
- (void)setDrawBorder:(BOOL)flag;
@end

@interface NSObject (MCCalendarDatePickerViewDelegate)

// Gets called when the date changes, but not by the user directly clicking on the monthview, but rather changing the visible range which has the side effect of changing the date
- (void)calendarDatePickerView: (MCCalendarDatePickerView*)view updatedUIAndSoftSelectedDate: (NSCalendarDate*)date;

@end
